-- Student Document Group Master Event

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='DOCUMENT_GROUP_MASTER');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'STUDENT_DOCUMENT_GROUP_MASTER_REQUEST', 'Student Document Group Master Request', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Student Document Group Master Request');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT');



SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select 
T1.id As USER_ID

from person_required_doc_group_master T1
where T1.id in (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select 
T1.id AS ID,
T5.firstName AS FIRST_NAME,
T5.lastName AS LAST_NAME,
T5.printName AS PRINT_NAME,
T5.emailId AS EMAIL_ID,
T5.alternateEmailId AS ALTERNATE_EMIAL_ID,
T5.mobileNumber AS MOBIULE_NO,
DATE_FORMAT(T3.dueOn , '%d %M, %Y')  As DUE_DATE,
GROUP_CONCAT(T2.documentName SEPARATOR ',') As DOCUMENT_NAME,
T7.displayName AS ACADEMY_NAME_LOCATION

from person_required_doc_group_master T1
left join document_group_master T3 on T3.id=T1.documentGroupMasterId 
left join document_group_master_required T2 on T2.documentGroupMasterId=T3.id
inner join students T4 on T4.personId=T1.personId
left join persons T5 on T5.id=T4.personId
left join user_academy_locations T6 on T6.userId = T5.id
left join academy_location T7 ON T7.id = T6.academyLocationId
where T1.id in (namedParams) group by T1.personId ",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },		 
		 {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },{
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },{
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		 {
            "id": 5,
            "value": "dueOn",
            "resultKey": "DUE_DATE",
            "displayCode": "",
            "displayOrder": 4
        },
		 {
            "id": 6,
            "value": "documentName",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		 {
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        }
]}');



SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='STUDENT_DOCUMENT_GROUP_MASTER_REQUEST');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='DOCUMENT_GROUP_MASTER');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Student Document Group Master Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templatedtproviderId+1,NULL,'Student Document Group Master Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Document Group Master Request','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
            
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,&nbsp</br>You have been requested to submit following documents by <strong>$recipientData[&quot;DUE_DATE&quot;]</strong>. Please login to student portal and do the needful.</span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px; text-decoration: underline;"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Documents Requireds:</strong></span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px;"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> <strong>$recipientData[&quot;DOCUMENT_NAME&quot;]</strong></span></span></p>

 <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thanks and regards,&nbsp;</br> <strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>
		
			</td>
		</tr>
		
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'4','Document Group Master Request','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
            
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,&nbsp</br>You have been requested to submit following documents by <strong>$recipientData[&quot;DUE_DATE&quot;]</strong>. Please login to student portal and do the needful.</span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px; text-decoration: underline;"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Documents Requireds:</strong></span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px;"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> <strong>$recipientData[&quot;DOCUMENT_NAME&quot;]</strong></span></span></p>

 <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thanks and regards,&nbsp;</br> <strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>
		
			</td>
		</tr>
		
</table>
</body>
</html>');

set sql_safe_updates=0;
update msg_template_config set templatelanguageValue= 'English' where templatelanguageValue is null;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
set sql_safe_updates=1;


